﻿//////////////////////////////////////////////
// BmpDibHeader.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkImages
#include "../Enums/BmpColorSpace.h"
#include "../Enums/BmpCompression.h"
#include "../Enums/BmpDibHeaderVersion.h"
#include "../Enums/BmpIntent.h"

// nkMemory
#include <NilkinsMemory/Containers/BufferView.h>

/// Class ------------------------------------

namespace nkImages::bmp
{
	class BmpDibHeader final
	{
		public :

			// Constants
			inline static unsigned int V3_BYTE_SIZE = 40 ;
			inline static unsigned int V4_BYTE_SIZE = 108 ;
			inline static unsigned int V5_BYTE_SIZE = 124 ;

		public :

			// Functions
			// Encode
			bool encodeInData (const nkMemory::BufferView<unsigned char>& data) ;
			// Decode
			bool decodeFromData (const nkMemory::BufferView<unsigned char>& data) ;

		public :

			// Attributes
			// Header size (12 bytes in theory)
			unsigned int _headerSize = 0 ;

			// Dimensions of image
			int _imageWidth = 0 ;
			int _imageHeight = 0 ;

			// Color planes (apparently must be 1)
			unsigned short _colorPlanes = 0 ;

			// Bits per pixel
			unsigned short _pixelBitsSize = 0 ;

			// Compression used
			BMP_COMPRESSION _compression = BMP_COMPRESSION::BI_RGB ;

			// Size of bitmap data
			unsigned int _bitmapDataByteSize = 0 ;

			// Resolution of image
			unsigned int _horizontalPpm = 0 ;
			unsigned int _verticalPpm = 0 ;

			// Palette info
			unsigned int _paletteColorNumber = 0 ;
			unsigned int _paletteImportantColorNumber = 0 ;

			// Win V4
			// Masks
			unsigned int _redMask = 0 ;
			unsigned int _greenMask = 0 ;
			unsigned int _blueMask = 0 ;
			unsigned int _alphaMask = 0 ;

			// Color space
			BMP_COLOR_SPACE _colorSpaceType = BMP_COLOR_SPACE::LCS_CALIBRATED_RGB ;
			unsigned int _cieRedX = 0 ;
			unsigned int _cieRedY = 0 ;
			unsigned int _cieRedZ = 0 ;
			unsigned int _cieGreenX = 0 ;
			unsigned int _cieGreenY = 0 ;
			unsigned int _cieGreenZ = 0 ;
			unsigned int _cieBlueX = 0 ;
			unsigned int _cieBlueY = 0 ;
			unsigned int _cieBlueZ = 0 ;
			unsigned int _gammaRed = 0 ;
			unsigned int _gammaGreen = 0 ;
			unsigned int _gammaBlue = 0 ;

			// Win V5
			BMP_INTENT _profileIntent = BMP_INTENT::LCS_GM_ABS_COLORIMETRIC ;
			unsigned int _profileDataOffset = 0 ;
			unsigned int _profileByteSize = 0 ;

			unsigned int _reserved = 0 ;

			// Header version
			BMP_DIB_HEADER_VERSION _version = BMP_DIB_HEADER_VERSION::WIN_V5 ;
	} ;
}